function out = fct_decomposition_increments_observables(DECinput)

    mm_mat = fieldnames( DECinput );
    for i = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(i)) '= DECinput.(cell2mat(mm_mat(i)));']);
    end
    
    % number of groups
    NG = size(g_vec_group,2);
    K  = length(mu_vec);
    
    % decomposition of group-specific hazard rate    
    DECOMPinput.mu_vec = mu_vec;
    DECOMPinput.sigma_vec = sigma_vec;
    DECOMPinput.tmin  = 0;
    DECOMPinput.tmax  = 104;
    DECOMPinput.g_vec = g_vec;
    
    % aggregate decomposition
    DECOMPagg = fct_decomposition_increments(DECOMPinput);
    
    % group-specific decomposition
    for i = 1:NG
        DECOMPinput.g_vec = g_vec_group(:,i);         
        DECOMPoutput = fct_decomposition_increments(DECOMPinput);
        
        HR_agg_group(:,i) = DECOMPoutput.HR_agg;
        HR_struc_multi_group(:,i) = DECOMPoutput.HR_struc_multi;
        HR_heter_multi_group(:,i) = DECOMPoutput.HR_heter_multi;
        tgrid_group(:,i) = DECOMPoutput.tgrid;
    end
               
    % between-group heterogeneity
    tgrid = tgrid_group(:,1)';
    Nt    = length(tgrid);
    dt    = [tgrid(2)-tgrid(1) diff(tgrid)];
           
    Fgrid = zeros(K,Nt);
    %fgrid = zeros(K,Nt);
    gsurv_gr = zeros(K,Nt,NG);  % survivor distribution for each group
    share = zeros(Nt,NG);       % share of each group for different durations
    %gsurv = zeros(K,Nt);        % survivor for all types
         
    % conditional distribution
    for k = 1:K
        mu    = mu_vec(k);
        sigma = sigma_vec(k);
            
        Fgrid(k,:) = fct_CDF_F_capped(tgrid,mu,sigma);    
        for i = 1:NG
            gsurv_gr(k,:,i) = g_vec_group(k,i)*(1-Fgrid(k,:));          
        end
            %gsurv(k,:) = g_vec(k)*(1-Fgrid(k,:));           
    end
        
    %gsum = sum(gsurv,1);
    %gsurv = gsurv./repmat(gsum,K,1);
            
    % share of each type over time
    for i = 1:NG
        gsurv_i = squeeze(gsurv_gr(:,:,i));
        share(:,i)  = shareT0(i)*sum(gsurv_i,1);
    end
    share_sum = sum(share,2);
    group_share = share./repmat(share_sum,1,NG);
        
    delta_HR_B_multi = zeros(Nt,1);
    log_HR_B_multi   = zeros(Nt,1);
    
    for t = 2:Nt
        tind  = t;                % index: position in the vector

        share_s   = group_share(tind,:) ;  % g(k,t) is the distribution of suriviers of type k at t
        share_s_1 = group_share(tind-1,:);

        dshare = (share_s - share_s_1) ; % change in survivers begtween weeks        
        delta_HR_B_multi(tind) = dshare*(HR_agg_group(tind,:)/DECOMPagg.HR_agg(tind))';
                      
        log_HR_B_multi(tind) = log_HR_B_multi(tind-1) + delta_HR_B_multi(tind)*dt(tind);        
    end                  
    HR_B_multi = exp(log_HR_B_multi);    

    % output
    out.HR_agg_group = HR_agg_group;
    out.HR_struc_multi_group = HR_struc_multi_group;
    out.HR_heter_multi_group = HR_heter_multi_group;
    out.HR_B_multi = HR_B_multi;
    out.group_share = group_share;
    out.tgrid = tgrid;       

return